/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.item;

import com.google.common.collect.ImmutableList;
import com.minecraftabnormals.neapolitan.common.item.DrinkItem;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanEffects;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanItems;
import java.util.Collection;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class MilkshakeItem
extends DrinkItem {
    private final EffectType effectType;

    public MilkshakeItem(EffectType effectType, Item.Properties builder) {
        super(builder);
        this.effectType = effectType;
    }

    @Override
    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entity) {
        this.handleEffects(entity);
        return super.func_77654_b(stack, worldIn, entity);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return ActionResultType.PASS;
        }
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_219711_mW, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)player;
            CriteriaTriggers.field_193138_y.func_193148_a(serverplayerentity, stack);
            serverplayerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
        if (entity.func_70660_b((Effect)NeapolitanEffects.VANILLA_SCENT.get()) == null) {
            this.handleEffects(entity);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
            ItemStack itemstack = new ItemStack((IItemProvider)Items.field_151069_bo);
            if (!player.field_71071_by.func_70441_a(itemstack)) {
                player.func_71019_a(itemstack, false);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void handleEffects(LivingEntity user) {
        ImmutableList effects = ImmutableList.copyOf((Collection)user.func_70651_bq());
        if (this.getEffectType() != null) {
            for (int i = 0; i < effects.size(); ++i) {
                Effect effect = ((EffectInstance)effects.get(i)).func_188419_a();
                if (effect.func_220303_e() != this.getEffectType() && (this.getEffectType() != EffectType.HARMFUL || effect != Effects.field_220309_E) && this.getEffectType() != EffectType.NEUTRAL) continue;
                user.func_195063_d(effect);
            }
        } else {
            LivingEntity nearest = user.field_70170_p.func_217360_a(LivingEntity.class, EntityPredicate.field_221016_a.func_221012_a(living -> living != user && living.func_70660_b((Effect)NeapolitanEffects.VANILLA_SCENT.get()) == null), user, user.func_226277_ct_(), user.func_226278_cu_(), user.func_226281_cx_(), user.func_174813_aQ().func_72314_b(6.0, 2.0, 6.0));
            if (nearest != null) {
                ImmutableList nearestEffects = ImmutableList.copyOf((Collection)nearest.func_70651_bq());
                if (this == NeapolitanItems.BANANA_MILKSHAKE.get()) {
                    user.func_195061_cb();
                    nearest.func_195061_cb();
                    effects.forEach(arg_0 -> ((LivingEntity)nearest).func_195064_c(arg_0));
                    nearestEffects.forEach(arg_0 -> ((LivingEntity)user).func_195064_c(arg_0));
                } else if (this == NeapolitanItems.MINT_MILKSHAKE.get()) {
                    nearest.func_195061_cb();
                    nearestEffects.forEach(arg_0 -> ((LivingEntity)user).func_195064_c(arg_0));
                } else if (this == NeapolitanItems.ADZUKI_MILKSHAKE.get()) {
                    user.func_195061_cb();
                    effects.forEach(arg_0 -> ((LivingEntity)nearest).func_195064_c(arg_0));
                }
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    @Override
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public SoundEvent func_225520_U__() {
        return SoundEvents.field_226141_eV_;
    }

    public SoundEvent func_225519_S__() {
        return SoundEvents.field_226141_eV_;
    }

    public EffectType getEffectType() {
        return this.effectType;
    }
}

